import pandas as pd
import numpy as np
import pickle

atp_tennis = pd.read_csv('atp_tennis.csv')

def calculate_performance(player, opponent, data, surface_types):   
    player_matches = data[((data['Player_1'] == player) & (data['Player_2'] == opponent)) | ((data['Player_1'] == opponent) & (data['Player_2'] == player))]   
    total_matches = len(player_matches)   
    wins = len(player_matches[player_matches['Winner'] == player])   
    win_rate = wins / total_matches if total_matches > 0 else 0   
    h2h_record = wins / total_matches if total_matches > 0 else 0   

    surface_performance = {}   
    for surface in surface_types:   
        player_surface_matches = player_matches[player_matches['Surface'] == surface]   
        player_surface_wins = len(player_surface_matches[player_surface_matches['Winner'] == player])   
        surface_performance[surface] = player_surface_wins / player_surface_matches.shape[0] if player_surface_matches.shape[0] > 0 else 0   

    return win_rate, h2h_record, surface_performance   
